import random


def generer_tableau(taille):
    """
    Génère un tableau non trié de taille "taille" contenant tous les nombres compris entre 1 et "taille".

    Paramètres :
    taille -- Taille du tableau

    Retour :
    Un tableau
    """
    tableau = [v for v in range(1, taille + 1)]
    random.shuffle(tableau)
    return tableau


def generer_matrice_carree(taille):
    """
    Génère un tableau à deux dimensions contenant des nombres compris entre 1 et taille**2.

    Paramètres :
    taille -- Taille de la matrice carrée

    Retour :
    Un tableau à deux dimensions
    """

    return [[random.randint(1, taille ** 2) for j in range(taille)] for i in range(taille)]


def generer_tableau_trie(taille):
    """
    Génère un tableau trié de taille "taille" contenant tous les nombres compris entre 1 et "taille".

    Paramètres :
    taille -- Taille du tableau

    Retour :
    Un tableau
    """
    return [v for v in range(1, taille + 1)]
