def caractere_mot(c):
    """
    Renvoie True si le caractère peut apparaître dans un mot, False sinon

    Paramètres :
    c - un caractère (chaîne de caractères de longueur 1)

    >>> caractere_mot('x')
    True
    >>> caractere_mot('-')
    True
    >>> caractere_mot(' ')
    False
    """
    assert len(c) == 1
    return 'a' <= c <= 'z' or 'A' <= c <= 'Z' or c in 'àâäéèêëîïôöùûüÀÂÄÉÈÊËÎÏÔÖÙÛÜ-'


def _incrementer_dictionnaire(dictionnaire, cle):
    """
    Incrémente la valeur d'une clé dans un dictionnaire.
    - La clé est une chaîne de caractère qui est automatiquement convertie en minuscule
    - La fonction prend en charge le cas d'une clé non présente dans le dictionnaire

    Paramètres
    dictionnaire -- Le dictionnaire dont on souhaite incrémenter des valeurs
    cle -- La clé dont la valeur doit être incrémentée

    Test
    >>> dictionnaire = {"a":1}
    >>> _incrementer_dictionnaire(dictionnaire, "a")
    >>> _incrementer_dictionnaire(dictionnaire, "b")
    >>> dictionnaire
    {'a': 2, 'b': 1}
    """
    cle = cle.lower()
    dictionnaire[cle] = dictionnaire[cle] + 1 if cle in dictionnaire else 1


def compter_mots(chaine):
    """
    Renvoie un dictionnaire contenant le nombre d'occurences de chaque mot de << chaine >>

    Paramètre :
    chaine - une chaine de caractères

    Test :
    >>> compter_mots('bonjour, au revoir ! Re-bonjour et encore au revoir.')
    {'bonjour': 1, 'au': 2, 'revoir': 2, 're-bonjour': 1, 'et': 1, 'encore': 1}
    >>> compter_mots('hello, world')
    {'hello': 1, 'world': 1}
    """
    mot = ""
    occurrences = {}

    for c in chaine:
        if caractere_mot(c):
            mot += c
        elif mot != "":
            mot = mot.strip('-')
            _incrementer_dictionnaire(occurrences, mot)
            mot = ""

    # Si le tampon n'est pas vide à la fin du parcours du tableau
    if mot != "":
        _incrementer_dictionnaire(occurrences, mot)

    return occurrences


if __name__ == '__main__':
    import doctest

    doctest.testmod()
